(function() {
	CKEDITOR.plugins.add('embed', {
		requires: ['iframedialog'],
		init: function(editor) {
			var me = this;

			CKEDITOR.dialog.add('embedDialog', function(editor) {
				return {
					title: 'HTML / Embed / Video',
					minWidth: 550,
					minHeight: 200,
					contents: [{
						id: 'iframe',
						label: 'Embed',
						expand: true,
						elements: [{
							type: 'html',
							id: 'pageembed',
							label: 'HTML / Embed / Video',
							style: 'width:100%; height:210px;',
							html: '<iframe src="'+me.path+'/dialogs/embed.html?xxx" frameborder="0" name="iframeembed" id="iframeembed" allowtransparency="1" style="width:100%;height:220px;margin:0;padding:0;"></iframe>'
						}]
					}],
					onOk: function() {
						for(var i=0; i<window.frames.length; i++) {
							if(window.frames[i].name=='iframeembed') {
								var content = window.frames[i].document.getElementById("embed").value;
							}
						}
						final_html='embedInsertData|---'+escape('<p>'+content+'</p>')+'---|embedInsertData';
						editor.insertHtml(final_html);
						updated_editor_data = editor.getData();
						clean_editor_data = updated_editor_data.replace(final_html,'<p>'+content+'</p>');
						editor.setData(clean_editor_data);
					}
				};
			});

			editor.addCommand('embed', new CKEDITOR.dialogCommand('embedDialog'));
			editor.ui.addButton('Embed', {
				label: 'HTML / Embed / Video',
				command: 'embed',
				icon: this.path+'images/icon.gif'
			});
		}
	});
})();