<?
/*
$X->IMG->rotate($plik, $angle, array('w'=>200, 'h'=>200, 'dir'=>USR.'/zdjecia', 'name'=>'_', 'crop'=>1, 'watermark'=>array('watermark.png','left','bottom',30,10)));
*/

//	function rotate($src, $angle, $param) {
		global $X;

		$ext=$X->FILE->get_ext($src);
		if(!file_exists($src) || !is_file($src) || empty($ext)) return false;
		$original_file=@array_pop(explode('/',$src));

		switch($ext) {
			case 'jpg':
			case 'jpeg':	$source=imagecreatefromjpeg($src);	break;
			case 'gif':		$source=imagecreatefromgif($src);	break;
			case 'png':		$source=imagecreatefrompng($src);	break;
		}

		if(!is_numeric($angle)) {
			switch(strtolower($angle)) {
				default:			return true;	break;
				case 'l':
				case 'left':	$angle=90;		break;
				case 'r':
				case 'right':	$angle=270;		break;
				case 't':
				case 'top':
				case 'b':
				case 'bottom':	$angle=180;		break;
			}
		}

		$source=imagerotate($source, $angle, 0);
		$width=imagesx($source);
		$height=imagesy($source);
		$orientation=($width>=$height ? 'h':'v');
		$proportion=$width/$height;


			$to_crop_w = $to_crop_h = 0;
			$new_image_width  = $new_width  = $width;
			$new_image_height = $new_height = $height;
			if(!is_numeric($param['quality'])) $param['quality']=85;



			if($param['crop']==1) {
				if($orientation=='v') { //width resize, crop height
					$new_width=$param['w'];
					$new_height=$new_width/$width;
					$new_height=round($new_height*$height);
					$to_crop_h=round(($new_height-$param['h'])/2);
				} else { //height resize, crop width
					$new_height=$param['h'];
					$new_width=$new_height/$height;
					$new_width=round($new_width*$width);
					$to_crop_w=round(($new_width-$param['w'])/2);
				}
				$new_image_width=$param['w'];
				$new_image_height=$param['h'];
			} else {
				if($width>$param['w'] || $height>$param['h']) {
					if($width>$param['w']) {
						$new_width=$param['w'];
						$new_height=$new_width/$width;
						$new_height=$new_height*$height;
					}

					if($new_height>$param['h']) {
						$new_height=$param['h'];
						$new_width=$new_height/$height;
						$new_width=$new_width*$width;
					}
				}

				(int)$new_width=round($new_width);
				(int)$new_height=round($new_height);
				if($new_width+1<$param['w'] && ($new_width+1/$new_height)<$proportion) $new_width++;
				if($new_height+1<$param['h'] && ($new_width/$new_height+1)<$proportion) $new_height++;

				$new_image_width=$new_width;
				$new_image_height=$new_height;
			}

			(int)$to_crop_w=($to_crop_w<0 ? 0 : $to_crop_w);
			(int)$to_crop_h=($to_crop_h<0 ? 0 : $to_crop_h);

			$thumb=imagecreatetruecolor($new_image_width, $new_image_height);
			$new_file_name=(!empty($param['dir']) ? $param['dir'].'/'.$X->FILE->add_suffix($original_file, $param['name']) : $X->FILE->add_suffix($src, $param['name']));
			if(!empty($param['dir'])) @mkdir($param['dir'], 0755);


			switch($ext) {
				case 'jpg':
				case 'jpeg':
					imagecopyresampled($thumb, $source, -$to_crop_w, -$to_crop_h, 0, 0, $new_width, $new_height, $width, $height);
					imagejpeg($thumb, $new_file_name, $param['quality']);
				break;

				case 'gif':
					$gif_info = $CS->IMAGE->GIF_info($src);
					if($gif_info['version']=='89a' && $gif_info['color_flag']==1) {
						$transparent=imagecolorallocate($thumb, $gif_info['transparent_r'], $gif_info['transparent_g'], $gif_info['transparent_b']);
						imagecolortransparent($thumb, $transparent);
					}
					imagecopyresampled($thumb, $source, -$to_crop_w, -$to_crop_h, 0, 0, $new_width, $new_height, $width, $height);
					imagegif($thumb, $new_file_name);
				break;

				case 'png':
					imagealphablending($thumb, false);
					imagesavealpha($thumb,true);
					$transparent = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
					imagefilledrectangle($thumb, 0, 0, $new_width, $new_height, $transparent);
					imagecopyresampled($thumb, $source, -$to_crop_w, -$to_crop_h, 0, 0, $new_width, $new_height, $width, $height);
					imagepng($thumb, $new_file_name);
				break;

				default:
					return false;
				break;
			}
			@chmod($new_file_name, 0644);


		unset($thumb);
		unset($source);
		unset($watermark);

		return true;
//	}
?>