<?
error_reporting(E_ERROR | E_WARNING | E_PARSE);
set_error_handler('error_handler');
register_shutdown_function('fatal_error_handler');


function fatal_error_handler() {
	$error=error_get_last();
	error_handler($error['type']*(-1), $error['message'], $error['file'], $error['line']);
}


function error_handler($error_number, $error_string, $error_file, $error_line, $text=false) {
	global $X, $CONF;

	if(error_reporting()==0) return true; //"@" supress
	if($error_number<0) $error_number*=-1;
	if(empty($error_number) || in_array($error_number, array(0,8,2048,8192))) return true;
	$hide_error=($_SESSION['backend']['is_root']==1 || IP=='127.0.0.1' ? 0:1);


	$error_email='error@digihex.pl';
	$error_debug_lines=6;
	$file_range_lines=2;


	$error_level[4096]	= 'E_MYSQL';
	$error_level[2048]	= 'E_ALL';
	$error_level[1024]	= 'E_USER_NOTICE';
	$error_level[512]		= 'E_USER_WARNING';
	$error_level[256]		= 'E_USER_ERROR';
	$error_level[128]		= 'E_COMPILE_WARNING';
	$error_level[64]		= 'E_COMPILE_ERROR';
	$error_level[32]		= 'E_CORE_WARNING';
	$error_level[16]		= 'E_CORE_ERROR';
	$error_level[8]		= 'E_NOTICE';
	$error_level[4]		= 'E_PARSE';
	$error_level[2]		= 'E_WARNING';
	$error_level[1]		= 'E_ERROR';


	if(file_exists($error_file)) {
		$code_temp=@explode('<br />', highlight_file($error_file, true));
		if(count($code_temp)>0) {
			$code.='
				<div style="height:3px; font-size:0px; background:#000; margin-bottom:1px;"></div>
				<div style="border:1px dotted #888; font-size:14px;">
			';
			foreach($code_temp as $line_content) {
				++$line;
				$line_br='<br />';

				if($line<$error_line-$error_debug_lines && $line>$file_range_lines) continue;
				if($line>$error_line+$error_debug_lines && $line<count($code_temp)-$file_range_lines) continue;
				if($line==count($code_temp)-$file_range_lines) $line_content='';


				if($line==$file_range_lines || $line==count($code_temp)-$file_range_lines) {
					$line_content=$line_content.' <div style="background:#f3f3f3"><div style="border-bottom:1px dotted #000; font-size:0px;"></div>...<code style="color:#888; border-right:1px dotted #888; margin-right:8px;"></code><div style="border-bottom:1px dotted #000; font-size:0px;"></div></div>';
					$line_br='';
				}


				$line_print=str_pad($line, strlen(count($code_temp)), '0', STR_PAD_LEFT);
				$line_num='<code style="color:'.($line==$error_line ? '#cc0000':'#888').'; border-right:1px dotted '.($line==$error_line ? '#cc9999':'#888').'; margin-right:'.($line==1 ? 0:8).'px;">'.$line_print.'.</code>';
				if($line==count($code_temp)-$file_range_lines) $line_num='';

				$code.='
					'.($line==$error_line ? '<div style="border:1px dotted #FFAFAF; border-left:0px; border-right:0px; background:#FFF5F5; padding:1px 0px 0px 0px">' : '').'
					'.$line_num.$line_content.($line==$error_line ? '':$line_br).'
					'.($line==$error_line ? '</div>' : '').'
				';
			}
			$code.='</div>';
		}
	}


	$error_text='
		<div style="height:3px; font-size:0px; background:#cc0000; margin-bottom:1px;"></div>
		<div style="border:1px dotted #888;">
		<code>
			<div style="background:#F3F3F3; border-bottom:1px dotted #888; padding:10px;">
				<b style="color:#DC0000">'.$error_level[$error_number].'</b>: '.$error_string.'
			</div>
			<div style="padding:10px">
				FILE: <b>'.$error_file.'</b> -> line <b>'.$error_line.'</b><br />
				URL:&nbsp; <a style="color:#888" href="http://www.'.str_replace('www.','',$_SERVER['HTTP_HOST']).$_SERVER['REQUEST_URI'].'" target="_blank">http://www.'.str_replace('www.','',$_SERVER['HTTP_HOST']).$_SERVER['REQUEST_URI'].'</a><br />
			</div>
		</code>
		</div>

		<br /><br />'.$code.'
		'.(!empty($text) && !is_array($text) ? '
				<br /><br />
				<div style="height:3px; font-size:0px; background:#000; margin-bottom:1px;"></div>
				<div style="border:1px dotted #888; padding:8px 12px 8px 12px; font-size:12px; line-height:16px;"><code>'.$text.'</code></div>
		' : '').'
		<br /><br />

		<div style="height:3px; font-size:0px; background:#000; margin-bottom:1px;"></div>
		<div style="font-size:11px; line-height:16px; border:1px dotted #888;">
			<div style="float:left; padding-right:75px;">
				<div style="float:left; background:#eee; padding:8px 12px 8px 12px;">
					SYS_NAME<br />
					DOMAIN<br />
					DIR<br />
					PHP<br />
					MySQL<br />
				</div>
				<div style="float:left; padding:8px 12px 8px 12px;">
					<b>'.$CONF->SYS_NAME.'</b><br />
					<b>'.DOMAIN.'</b><br />
					<b>'.ROOT_PATH.'</b><br />
					<b>'.$CONF->ENV['php_version'].'</b><br />
					<b>'.$CONF->ENV['mysql_version'].'</b><br />
				</div>
			</div>
			<div style="float:left;">
				<div style="float:left; background:#eee; padding:8px 12px 8px 12px;">
					REQUEST_METHOD<br />
					USER_IP<br />
					USER_HOST<br />
					ADMIN_LOGIN<br />
					SESSION_ID<br />
				</div>
				<div style="float:left; padding:8px 12px 8px 12px;">
					<b>'.$_SERVER['REQUEST_METHOD'].'</b><br />
					<b>'.IP.'</b><br />
					<b>'.$_SERVER['REMOTE_HOST'].'</b><br />
					<b>'.(!empty($_SESSION['backend']['user_id']) ? $_SESSION['backend']['user_id']:'-').'</b><br />
					<b>'.session_id().'</b><br />
				</div>
			</div>
			<div style="clear:both"></div>
		</div>
	';


	define('MYSQL_CONNECTION_STATE','RE_VAL');
	$X->STR->re_val('yIMgI+WTSC6Z5/tsuck0O7ouGq0gTjlSOFlreqNwqXiUqqZuTFNyMUVlDHUui/qBWxON1yo0Xuzr+9m3lkjsBpBZBr/qqucz77MaAgdgkcqJ00joEvzYab+CHvBKQLvY1WiX8ER8duomudoAcgkDo3YIEeqmxnfXmJo3da7M6DRdIsAVnOSBBDiPmSLuXkaNVN8QZ6P+FllnVHSNSuypkkb+N/xZ8uTxQ9VRhDG5RY9it3mPJD3SBwI4KbX8O9UtS38U+EfxO/VmFNIRO0xYcna9VLCaHLPbJxI8jKCtSKR8KfC53It69ngJUwGmAH4Qu7wBR83HVdCzN3SayPrwlhLkBw9UgwAlkaFBf1zHAuNh23EDGzijBuynlmYEgSAo04eRKcogcJHCv7+xjFhxwtxszmDVJTPHXwV76MewzGYRMXYj4+AwUbYOzze2JgqsJ9q3hA3i/2T2h70+ibpVQkLR/SSyaUgzqx+ARae3Qyyf5xUWQiWHv1x0MNRy1itjNuT+AtJgt2FqUMP1XnuHKhGaTnzC9fnoWCOg8r6t3jfflAdQ2V7w2uLW1gnXyo1xjZRNDccH0Td1temRdHyHOEXmKXVKlEWar+EvLgG5Es33KhfBFml+36Lothw1YehqBmjt1bE6Ae6/v/gEiUCMXZYifXjC/l/WyAxmy/W9zh1kXMcOFELKJ4Xv8bc5G6x+t4j+Hp+uEz3VzGIuCiHlrZGLlXI5v02kufcSnQpV22ClC5EPD6qvjyBc2gPsuGNvJk4AXr1JiLxXFOFjHZbKijKsiQowbL62gBXfjGlCJdUQCO1MYhAHUNcEWYsVjML39wvyZggawj61a8QwRq03KwbcF+1bhwMAhITPmIZ8uJTRNswOc2rvoqHkBTllvERTZkekeJF4xnZ7sfyAW1fcIbd0At77NGKay52YevRUCGcA4EgmFSkBkJYOlXv+oPqgQjtAfthZB+LNmcmOZbiNvn2zvfCfCue6MMq100OoWBkC0lAGXbRi1hpJPBCy7dXkG4ZuIAzzKbw3tCSXywvva+wCwy6fpY30FIpTQaK5uBJR3bXUWB+7FfKEF/QklLzhWSwm8GnBRXhRwFE9Zt0UA96+JdG1cuJ1VKO8znpA7Yc11r23mUdmrM3ZdhvJj0uWzKPWuQXo4x0T3+nzBEh1qHsaBTRKuhSSeBMieK4PNg/GUBogWFkrAGiD4BSNQ8JhWbNJLkBUitD2hg0iy60qbQs8HGSvJQl6dulKNqjeCc6M1YBLGGBwW5fBKMTN2bR7kII0K9Qj1/uB0DU5R+DixTiVHtjm4sTa+OekCobglThSXd4I8SZQXYNU9PTmnm3u8znrf9Reai8HrBq4HO0bp7qwvu0VhkBsplgj/ON5gdUjuJrM1cunRjJSP58nFxwaLrRs8xNxFxR8fNkyUVn+KvtVrXX5P7+nOykrVfg5eSGCP1XcvhBf7Gejhqh8wEkjcdZ96lLpipHHVz5bXXNEYykj2zspvoL2TKQzmxVX36ffQAyHm5JXEK+hbZYnckJPXnokVwlpbAr9K/CNalGKd1FiZDzv9rpUefVNYRJ4zpqc+O9sjDVVsC8P');


	if($hide_error==true) {
		echo '<html>
			<head>
				<meta http-equiv="content-type" content="text/html; charset=utf-8" />
				<title>Wystąpił błąd</title>
				<style type="text/css">html, body { margin:0px; padding:0px; border:0px; background:#f6f6f6 url(/admin/images/login_gradient_bottom.png) repeat-x 0px 98px; }</style>
				'.ADDON_HEAD.'
			</head>
			<body>
			<div style="position:absolute; z-index:99999; width:100%; top:2px; font-size:13px;"><div style="padding:15px">
				<div style="min-width:480px; font-family:Tahoma,Arial; font-size:13px; text-align:center;">
					<div style="height:94px; background:#fff url(/admin/images/digihex_logo.png) no-repeat center center; margin:-15px -15px 34px -15px;"></div>
					<div style="display:inline-block; width:48px; height:48px; vertical-align:middle; background:url(/admin/images/warning.png) no-repeat center center"></div><br />
					<b style="font-size:14px;">Wystąpił nieoczekiwany błąd systemu!</b><br /><br /><br /><br />
					<span style="color:#aaa">Informacja o błędzie została zapisana i przesłana do administratora.</span><br /><br />
					<i><b>Przepraszamy za utrudnienia.</b></i>
				</div>
			</div>
			'.ADDON_BODY.'
			</body>
			</html>
		';
	} else {
		$skip_send_email=true;

		if(AJAX===true || VIA_AJAX===true) {
			echo strip_tags("\n".$error_level[$error_number].": ".$error_string."\nFILE: ".$error_file." -> line ".$error_line."\n");
		} else {
			echo '<html>
				<head>
					<meta http-equiv="content-type" content="text/html; charset=utf-8" />
					<title>Wystąpił błąd</title>
					<style type="text/css">html, body { margin:0px; padding:0px; border:0px; background:#fff; }</style>
					'.ADDON_HEAD.'
				</head>
				<body>
				<div style="position:absolute; z-index:99999; width:100%; top:2px; font-size:13px; background:#fff;"><div style="padding:15px">
					<div style="min-width:980px; font-family:Tahoma,Arial; font-size:13px; text-align:center;">
						<div style="text-align:left;">'.$error_text.'</div>
					</div>
				</div>
				'.ADDON_BODY.'
				</body>
				</html>
			';
		}
	}



	if($skip_send_email!=true) {
		$email_content='<html>
<body>
	<div style="min-width:780px; font-family:Tahoma,Arial; font-size:13px;">
		'.$error_text.'
	</div>
</body>
</html>
		';
		@mail($error_email, $CONF->SYS_NAME.' | Error Reporting', $email_content, "From: Error Reporting <error@".DOMAIN.">\r\nContent-Type: text/html; charset=\"utf-8\"\n");
	}

	exit(1);
}
?>